version 13 // indicates version
cls // clears backscroll display buffer
clear all // "start from scratch"
set more off // suppresses -more- prompts

/* load data */
cd "C:\Users\benja\Dropbox\BenjaminWork\ResearchProject\data\creation\data-sets and merge\leisure\recode"
use "leisure.dta" 

/* check for no duplicate entries */
bys nomem_encr: gen N = _N
assert N == 1
drop N // no duplicate entries
// individuals are nested in households, but this is ignored here 

/* rename variables (1) */
rename nomem_encr id

rename *cs08?(###)* .?(##)*
rename *cs09?(###)* .?(##)*
rename *cs10?(###)* .?(##)*
rename *cs11?(###)* .?(##)*
rename *cs12?(###)* .?(##)*
rename *cs13?(###)* .?(##)*
rename *cs14?(###)* .?(##)*

// drop unneccessary variables
drop ?125 ?126 ?241 ?242 ?243 ?244 ?245 ?246 ?408

// decode missings
mvdecode _all, mv(999)

/* rename variables (2) */
local k = 8
qui foreach letter in a b c d e f g {
	rename `letter'01 opcosts`k'
	label var opcosts`k' " How satisfied are you with the amount of leisure time that you have?"
	rename `letter'79 volunwork`k'
	label var volunwork`k' "Total voluntary work per week in hours"
	local k = `k' + 1
}

////////////////////// WIDE /////////////////////////////////
// stata2mplus using leisure, replace
/////////////////////////////////////////////////////////////

////////////////////// LONG /////////////////////////////////
reshape long opcosts volunwork, i(id) j(wave) 
stata2mplus using leisureLong, replace
/////////////////////////////////////////////////////////////

replace opcosts = 10 - opcosts

label define ol 0 "entirely satisfied" 10 "entirely dissatisfied"
label values opcosts ol

label var opcosts "Dissatisfaction with amount of leisure time (0=satisfied, 10=dissatisfied)"
label var volunwork "Total voluntary work in hours per week"

////////////// STATA FILE FOR MERGING ///////////////////////
saveold d05_leisure, replace
/////////////////////////////////////////////////////////////

